﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.Xrm.Sdk;
using PpmsDataService.Models;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;

namespace PpmsDataService.V1.Mappers
{
    public class VisnMap
    {
        public static async Task<IQueryable<Visn>> MapVisns(List<va_visn> ppmsVisns, string mapRelatedType, PpmsContext context)
        {
            var visns = new List<Visn> { };
            foreach (var ppmsVisn in ppmsVisns)
            {
                var visn = new Visn
                {
                   VisnNumber = ppmsVisn.va_name,
                   VisnName = ppmsVisn.ppms_visnname
                };

                //Extract the Related type from queryType string
                if (mapRelatedType.Contains("?$expand=Facilities"))
                    mapRelatedType = "Facilities";
                if (mapRelatedType.Contains("?$expand=CareSites"))
                    mapRelatedType = "CareSites";
                if (mapRelatedType.Contains("?$expand=Institutions"))
                    mapRelatedType = "Institutions";


                //Map Related Types
                switch (mapRelatedType)
                {
                    case "Facilities":
                        //Lookup and Map the related Facilities
                        var ppmsFacilities =
                            context.va_facilitySet.Where(i => i.va_visnid.Id == ppmsVisn.Id);
                        var ppmsFacilitiesList = ppmsFacilities.ToList();
                        visn.Facilities =
                            await FacilityMap.MapFacilities(ppmsFacilitiesList, "None", context);
                        break;
                    case "CareSites":
                        //Lookup and Map the Care Sites
                        var ppmsCareSites =
                            context.ppms_caresiteSet.Where(i => i.ppms_visnid.Id == ppmsVisn.Id);
                        var ppmsCareSitesList = ppmsCareSites.ToList();
                        visn.CareSites =
                            await CareSiteMap.MapCareSites(ppmsCareSitesList, "None", context);
                        break;
                    case "Institutions":
                        //Lookup and Map the Institutions
                        var ppmsInstitutions =
                            context.ppms_institutionSet.Where(i => i.ppms_visn.Id == ppmsVisn.Id);
                        var ppmsInstitutionsList = ppmsInstitutions.ToList();
                        visn.Institutions =
                            await InstitutionMap.MapInstitutions(ppmsInstitutionsList, "None", context);
                        break;
                    default:
                        break;
                }

                visns.Add(visn);
            }
            return visns.AsQueryable();
        }      
    }
}